/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.hmcservc;

import com.ibm.hwmca.base.hmcservc.HmcServicesBean;
import com.ibm.hwmca.base.hmcservc.HmcServicesData;
import com.ibm.hwmca.base.hmcservc.HmcServicesErrorIds;
import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class HmcServicesTasklet
extends PanelTasklet
implements HmcServicesErrorIds {
    private static final String TRACE_MASKT = "HSRVTLTT";
    private static final String TRACE_MASKF = "HSRVTLTF";
    private static final String TRACE_MASKD = "HSRVTLTD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-42, "HmcServcTklt");
    private static final String AUIML = "com.ibm.hwmca.base.hmcservc.res.HmcServicesRes";
    private static final String PANEL = "HmcSrvsPanel";
    private static final String PARENT_BEAN = "BASETOWERSETTINGSBEAN";
    private HmcServicesBean bean;

    public HmcServicesTasklet() {
        Trace.trace(TRACE_MASKT, "<> HmcServicesTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        try {
            this.bean = new HmcServicesBean();
            this.bean.setBeanName("HmcServicesBean");
            HmcServicesData data = HmcServicesData.getHmcServicesData();
            this.bean.setRemoteOperationId(data.isRemoteOperationEnabled() ? "EnabledRemoteOperationItem" : "DisabledRemoteOperationItem");
            this.bean.setOpticalId(data.isOpticalEnabled() ? "EnabledOpticalItem" : "DisabledOpticalItem");
            this.bean.setCallAnsId(data.isCallAnsEnabled() ? "EnabledCallAnsItem" : "DisabledCallAnsItem");
            this.bean.setLICChangeId(HMC.getHMC().getLiccEnabled() ? "EnabledLICChangeItem" : "DisabledLICChangeItem");
            this.bean.setCIMManagementId(BaseTower.getBaseTower().isCimEnabled() ? "EnabledCIMManagementItem" : "DisabledCIMManagementItem");
            this.bean.setAccess(!User.getUser().hasAuth("base.rolegroup.operator"));
            this.bean.setLimitedAccess(User.getUser().hasAuth("base.rolegroup.advanced"));
        }
        catch (Exception e) {
            TaskletException texc = new TaskletException(e);
            new FrameworkLog(logInfo, 2, texc).log();
            throw texc;
        }
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                response.replace(AUIML, PANEL, this.bean);
            } else if (request.isDisposed() || request.isCanceled()) {
                PanelTaskletRequest newRequest = new PanelTaskletRequest();
                newRequest.setDisposed();
                if (this.isSubtasklet()) {
                    this.getParent().postRequest(PARENT_BEAN, newRequest);
                }
                response.terminate();
            } else {
                String action = (String)request.getData("action");
                Trace.trace(TRACE_MASKF, "action = " + action);
                if (action.equals("commit")) {
                    this.bean = (HmcServicesBean)request.getData("bean");
                    HmcServicesData data = HmcServicesData.getHmcServicesData();
                    data.setRemoteOperationEnabled(this.bean.getRemoteOperationId().equals("EnabledRemoteOperationItem"));
                    data.setOpticalEnabled(this.bean.getOpticalId().equals("EnabledOpticalItem"));
                    data.setCallAnsEnabled(this.bean.getCallAnsId().equals("EnabledCallAnsItem"));
                    HMC.getHMC().setLiccEnabled(this.bean.getLICChangeId().equals("EnabledLICChangeItem"));
                    BaseTower.getBaseTower().setCimEnabled(this.bean.getCIMManagementId().equals("EnabledCIMManagementItem"));
                    PanelTaskletRequest newRequest = new PanelTaskletRequest();
                    newRequest.setDisposed();
                    if (this.isSubtasklet()) {
                        this.getParent().postRequest(PARENT_BEAN, newRequest);
                    }
                    response.terminate();
                } else {
                    response.noAction();
                }
            }
        }
        catch (Exception e) {
            TaskletException texc = new TaskletException(e);
            new FrameworkLog(logInfo, 3, texc).log();
            throw texc;
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(logInfo, 1, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }
}

